/* global parameters */

let $$ = require('cdev/debug')({debug: 'cache', path: module.id, prefix: '[isg.xpert.archive]'});
$$.md = require('/agorum/roi/customers/cdev.ncore/js/utils/md')($$);
$$.objects = require('common/objects');

let aguila = require('common/aguila');
let utils = require('../idx-utils');
let archive = require('../archive');

let showMeta = false; // TODO: use archive ui settings

let idxView = aguila.create(require('./document-detail-view-aon')(showMeta));
let brick = idxView.down('viewDetails');
let details = idxView.down('idxMetaHeaderDetails');

idxView.on('idChanged', value => {
  // $$.debug('idxView - id changed - value', value);
  let obj = Array.isArray(value) ? $$.objects.tryFind(value.split('|').slice(-1)[0]) : $$.objects.tryFind(value);
  archive.updateForm(obj, 'Document', details);
  brick.raise('show', obj.ID);
});

setImmediate(() => {
  /* DEBUGGING *
  idxView.id = 'e3edcb70-3680-11ee-90a5-ce0d9d903e51'; // Document
  // idxView.id = '8fac2a10-3681-11ee-90a5-ce0d9d903e51'; // Record
  /**/
  if (parameters && parameters.external) {
    let obj = $$.objects.find(idxView.id);
    let meta = $$.md.load(obj, /^isg/);
    let header = '{0} - {1} - {2}'.format(
      meta.isg_xpert_archive_insNumber,
      meta.isg_xpert_archive_insName,
      utils.dateToString(meta.isg_xpert_archive_insBirthday)
    );
    let document = obj.name;
    let titles = {
      header: header,
      document: document,
    };
    $$.debug('setImmediate', idxView.id, parameters, titles);
    idxView.title = parameters.widgetTitle ? titles[parameters.widgetTitle] : null;
    idxView.form.title = parameters.windowTitle ? titles[parameters.windowTitle] : null;
  }
});

idxView;
